## Read argument
args<-commandArgs(TRUE)
print("begin")
print(args)
print("end")
N_index <- eval( parse(text=args[1]) )

args <- expand.grid(NR = c(T,F),
                    num_temp = c(3,5,7),
                    Nrep = c(1:20),
                    stoch_time = c(.1,1,2))

NR <- args[N_index,4] == 1;
ntemp <- args[N_index,3]; rep_1 = args[N_index,5];
stoch_time = args[N_index,2]; IT = args[N_index,6]
print(args[N_index,])

library(rstan)
load("bm/preprocess.Rdata")

stan_fit_eval <- stan("bm/ct_hmc_eval.stan", data = data,
                      iter = 1, chains = 1)
target <- function(x){
  stan_ev <- grad_log_prob(stan_fit_eval, c(x,1))
  d_log_q <- as.numeric(stan_ev)[1:p]
  log_q <- attr(stan_ev, "log_prob")

  return(list(log_q = log_q, d_log_q = d_log_q))
}
temper <- function(x){
  stan_ev <- grad_log_prob(stan_fit_eval, c(x,0))
  d_log_q <- as.numeric(stan_ev)[1:p]
  log_q <- attr(stan_ev, "log_prob")

  return(list(log_q = log_q, d_log_q = d_log_q))
}

source("parra_temp.R")
H <- sapply(1:p, function(i) sapply(1:p, function(j) {
  max( sum(pmax(0,data$q[,i]*data$q[,j])),
       sum(pmax(0,-data$q[,i]*data$q[,j])))
}))
diag(H) <- pmax(1, abs(1 - diag(H))) + 1

theta_0 <- rep(1,p)
hess_q1 <- matrix(H%*%theta_0[1:p],  nrow = 1)
hess_q0 <- matrix(abs(solve(tcrossprod(data$chol_sigma)))%*%theta_0[1:p], nrow = 1, byrow = T)
(hess <- abs(matrix(c(hess_q0,
                      hess_q1), nrow = 2,ncol = p, byrow = T)))
rownames(hess) <- c("q0", "q1")

x_init <- data$mu
theta_init <- rep(1,p)
log_bf <- 0
iters <- 2e4


##################################################
temp <- c(IT^c(ntemp:1),1)
source("parra_temp.R")

##################################################
IT <- 0.3
temp <- c(IT^c(ntemp:1),1)


set.seed(rep_1);
res <- pt(xinit = x_init, stoch_time = stoch_time,
          temp = temp, Nit = iters,
          even_odd_kernel = NR)

save(res,
     file = paste0("bm/PT/res_S_",stoch_time,"_NT_",ntemp,"_NR_",NR,"_rep_",rep_1,"_IT_",IT,".Rdata"))
rm(res)
gc()
##################################################
IT <- 0.5
temp <- c(IT^c(ntemp:1),1)


set.seed(rep_1);
res <- pt(xinit = x_init, stoch_time = stoch_time,
          temp = temp, Nit = iters,
          even_odd_kernel = NR)

save(res,
     file = paste0("bm/PT/res_S_",stoch_time,"_NT_",ntemp,"_NR_",NR,"_rep_",rep_1,"_IT_",IT,".Rdata"))
rm(res)
gc()
##################################################
IT <- 0.7
temp <- c(IT^c(ntemp:1),1)


set.seed(rep_1);
res <- pt(xinit = x_init, stoch_time = stoch_time,
          temp = temp, Nit = iters,
          even_odd_kernel = NR)

save(res,
     file = paste0("bm/PT/res_S_",stoch_time,"_NT_",ntemp,"_NR_",NR,"_rep_",rep_1,"_IT_",IT,".Rdata"))

